<?php 
include('authentication.php');
include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');
?>


<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>QR Code</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">QR Code</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">


                    <div class="card">
                        <div class="card-header">
                        <div class="row">
                                <div class="col-sm-6">
                                    <h5 class="m-0">QR Code List</h5>
                                </div><!-- /.col -->
                                <div class="col-sm-6">
                                    <a href="add-qrcode.php" class="btn btn-primary float-sm-right">Add QR Code</a>
                                     <a href="change-qrcode-status.php" class="btn btn-warning  mr-3 float-sm-right">Change QR Code Status</a>
                                </div><!-- /.col -->
                            </div>
                        </div>
                        
                        
                        
                      <div class="card-body">
                        <form action="qrcode.php" method="GET" id="catform" enctype="multipart/form-data">
                            <div class="form-group mb-3">
                                <input type="text" name="code" placeholder="Search QR Code" value="<?=$_GET['code']?>" class="form-control" required>
                                
                            </div>
                           
                            <div class="form-group mb-3">
                                <button type="submit"
                                    class="btn btn-primary float-sm-right">Submit</button>
                            </div>
                        </form>
                    </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Date</th>
                                        <th>Delar Name</th>
                                        <th>Location</th>
                                        <th>Unique Code</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                        $i = 1;
                        $ref = "QRSheet/";
                        try {
                            //28993
                          $fetchdata = $database->getReference($ref)->orderByChild('unique_code')->equalTo($_GET['code'])->getSnapshot();
                        
                        }
                        
                        //catch exception
                        catch(Exception $e) {
                          echo 'Message: ' .$e->getMessage();
                        }
                        
                        
                        $fetchdata = $fetchdata->getValue();
                        if($fetchdata>0){
                            foreach ($fetchdata as $key => $row) {
                                ?>
                                    <tr>
                                        <td><?=$i?></td>
                                        <td><?=$row['date']?></td>
                                        <td><?=$row['dealer_name']?></td>
                                        <td><?=$row['location']?></td>
                                        <td><?=$row['unique_code']?></td>
                                        <td>
                                            <?php if($row['status'] == 0){
                                                echo "Redeem";
                                            }else{
                                                echo "Not Redeem";
                                            } ?>
                                        </td>
                                        <td>
                                               <form action="code.php" method="POST" id="catform" enctype="multipart/form-data">
                                                   <input type="hidden" value="<?=$key?>" name="id">
                                             <select name="select_enable_disable" class="form-control mb-3" required>
                                    <option value="0" <?=$row['status'] == 0 ? ' selected="selected"' : '';?>>Redeem
                                    </option>
                                    <option value="1" <?=$row['status'] == 1 ? ' selected="selected"' : '';?>>Not Redeem
                                    </option>
                                </select>
                                <button type="submit" name="update_qr_code"
                                class="btn btn-primary float-sm-right">Submit</button>
                                <button type="submit" name="delet_qr_code"
                                class="btn btn-danger float-sm-right mr-3">Delete</button>
                                </form>
                                        </td>

                                    </tr>
                                    <?php
                                $i++;
                            }
                        }else{

                        }
                      
                      ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Date</th>
                                        <th>Delar Name</th>
                                        <th>Location</th>
                                        <th>Unique Code</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>


<?php
include('includes/script.php');
?>
<script>
$(document).ready(function() {
    $('.delete_btn').click(function(e) {
        e.preventDefault();
        var id = $(this).closest('tr').find('.id').text();
        console.log(id);
        $('#delete_id').val(id);
        $('#modal-danger').modal('show');

    });
});
</script>
<?php
include('includes/footer.php');
?>