<?php 
include('authentication.php');
include('includes/header.php');
include('includes/topbar.php');
include('includes/sidebar.php');
?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h3>Notifications</h3>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Notifications</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <section class="content">
    <?php include('message.php'); ?>
        <div class="container-fluid">



            <div class="card">
                <div class="card-header">
                    <h5>
                        Send Notifications
                    </h5>
                </div>
                <div class="card-body">
                    <form action="code.php" method="POST" id="catform" enctype="multipart/form-data">
                        <div class="form-group mb-3">
                            <input type="text" name="title" placeholder="Title" class="form-control" required>
                            
                        </div>
                        <div class="form-group mb-3">
                            <input type="text" name="desc" placeholder="Description" class="form-control" required>
                            
                        </div>
                        <div class="form-group mb-3">
                            <button type="submit" name="send_notification_btn"
                                class="btn btn-primary float-sm-right">Submit</button>
                        </div>
                    </form>
                </div>
                
            </div>
        </div>


    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Notifications Listing</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example2" class="table table-bordered table-hover">
                  <thead>
                  <tr>
                    <th>S No.</th>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Created At</th>
                  </tr>
                  </thead>
                  <tbody>
                      <?php
                         $i = 1;
                         $ref = "Notifications/";
                         $fetchdata = $database->getReference($ref)->getValue();
                         if($fetchdata>0){
                            foreach ($fetchdata as $key => $row) {
                                ?>
                                    <tr>
                                        <td><?=$i?></td>
                                        <td><?=$row['title']?></td>
                                        <td><?=$row['description']?></td>
                                        <td><?php echo(date('d/m/Y',$row['created_at']/1000))?></td>
                                    </tr>
                                <?php
                                $i++;
                            }
                        }else{

                        }
                        ?>
                
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>

</div>



<?php
include('includes/script.php');
include('includes/footer.php');
?>